/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.mobevent.MobEventClient;
import com.lycanitesmobs.core.mobevent.MobEventServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MobEventManager {
    public static MobEventManager instance;
    public Map<String, MobEventBase> allMobEvents = new HashMap<String, MobEventBase>();
    public Map<String, MobEventBase> worldMobEvents = new HashMap<String, MobEventBase>();
    public Map<String, Map<String, MobEventBase>> worldMobEventSets = new HashMap<String, Map<String, MobEventBase>>();
    public boolean mobEventsEnabled = true;
    public boolean mobEventsRandom = false;
    public boolean mobEventsSchedule = true;
    public int baseRate = 200;
    public int baseRange = 32;

    public MobEventManager() {
        instance = this;
    }

    public void loadMobEvents() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        config.setCategoryComment("Global", "These are various settings that apply to all events.");
        config.setCategoryComment("World", "These are various settings that apply to events on a per world basis. If your required world doesn't have its config values generated yet, you can generate them by entering the world in gae at least once.");
        this.mobEventsEnabled = config.getBool("Global", "Mob Events Enabled", this.mobEventsEnabled, "Set to false to completely disable the entire event system for every world.");
        this.mobEventsRandom = config.getBool("Global", "Random Mob Events Enabled", this.mobEventsRandom, "Set to false to disable random mob events for every world.");
        this.mobEventsSchedule = config.getBool("Global", "Mob Events Enabled", this.mobEventsSchedule, "Set to false to disable scheduled events for every world.");
        this.baseRate = config.getInt("Global", "Base Spawn Rate", this.baseRate, "Sets the base interval in ticks (20 ticks = 1 second) between each mob spawn, this is multiplied by 1.5 on easy and 0.5 on hard.");
        this.baseRange = config.getInt("Global", "Base Spawn Range", this.baseRange, "Sets the base range in blocks from each player/area that event mobs will spawn.");
        config.setCategoryComment("Events Enabled", "Here each event can be turned on or off (true or false).");
        config.setCategoryComment("Events Mob Durations", "Here you can set the duration (in ticks where 20 ticks = 1 second) of each event.");
        config.setCategoryComment("Events Forced Spawning", "Sets which events force their mobs to spawn, forced spawns will ignore other mods that interfere with mob spawning.");
        config.setCategoryComment("Events Forced No Despawning", "Sets which events force their spawned mobs to not despawn naturally (like most vanilla monsters do). However, mobs spawned by events will always only last 10 minutes and will then be forcefully despawned unless they are tamed by players, given a name tag, etc.");
        config.setCategoryComment("Event Day Minimums", "The minimum day before each event can occur randomly. For example if Shadow Games is set to 10 then it wont ever occured as a random event until day 10. Note: If Schedules and Locked Random events are active, the random event will not occur until both the Minimum Event day set here and first Schedule is met (by default schedules and event locks aren't used).");
        config.setCategoryComment("Event Dimensions", "Sets which dimensions (by ID) that this event WILL NOT occur in. However if 'Spawn Dimensions Whitelist Mode' is set to true, it will instead set which dimensions that this event WILL ONLY occur in. Multiple entries should be comma separated.");
    }

    public void addMobEvent(MobEventBase mobEvent) {
        if (mobEvent == null) {
            return;
        }
        mobEvent.loadFromConfig();
        this.allMobEvents.put(mobEvent.name, mobEvent);
    }

    public void addWorldEvent(MobEventBase mobEvent, String set) {
        if (mobEvent != null && mobEvent.hasSpawners()) {
            this.addMobEvent(mobEvent);
            if (!this.worldMobEventSets.containsKey(set)) {
                this.worldMobEventSets.put(set, new HashMap());
            }
            this.worldMobEventSets.get(set).put(mobEvent.name, mobEvent);
            this.worldMobEvents.put(mobEvent.name, mobEvent);
        }
    }

    public void addWorldEvent(MobEventBase mobEvent) {
        this.addWorldEvent(mobEvent, "main");
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        MobEventBase newEvent;
        World world = event.world;
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (world.field_72995_K || worldExt == null) {
            return;
        }
        if (worldExt.serverMobEvents.size() > 0) {
            for (MobEventServer mobEventServer : worldExt.serverMobEvents.toArray(new MobEventServer[worldExt.serverMobEvents.size()])) {
                mobEventServer.onUpdate();
            }
        }
        if (!this.mobEventsEnabled || !worldExt.mobEventsEnabled || world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (worldExt.serverWorldEvent != null) {
                worldExt.stopWorldEvent();
            }
            return;
        }
        if (worldExt.lastEventUpdateTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastEventUpdateTime = world.func_82737_E();
        if (world.field_73010_i.size() < 1) {
            return;
        }
        if (this.mobEventsSchedule) {
            if (!worldExt.eventScheduleLoaded) {
                worldExt.loadEventSchedule(worldExt.mobEventsSchedule);
            }
            if (worldExt.eventSchedule != null && worldExt.eventSchedule.size() > 0 && (newEvent = worldExt.getScheduledWorldMobEvent()) != null) {
                worldExt.startWorldEvent(newEvent);
            }
        }
        if (worldExt.serverWorldEvent != null) {
            worldExt.serverWorldEvent.onUpdate();
            return;
        }
        if (!this.mobEventsRandom || !worldExt.mobEventsRandom) {
            return;
        }
        if (worldExt.minEventsRandomDay > 0) {
            long l = worldExt.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D();
            if (Math.floor((double)l / 24000.0) < (double)worldExt.minEventsRandomDay) {
                return;
            }
        }
        if (worldExt.getWorldEventStartTargetTime() <= 0L || worldExt.getWorldEventStartTargetTime() > world.func_82737_E() + (long)worldExt.maxTicksUntilEvent) {
            worldExt.setWorldEventStartTargetTime(world.func_82737_E() + (long)worldExt.getRandomEventDelay(world.field_73012_v));
        }
        if (world.func_82737_E() >= worldExt.getWorldEventStartTargetTime() && (newEvent = this.getRandomWorldMobEvent(world, worldExt)) != null) {
            worldExt.startWorldEvent(newEvent);
        }
    }

    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (LycanitesMobs.proxy.getClientPlayer() == null) {
            return;
        }
        World world = LycanitesMobs.proxy.getClientPlayer().field_70170_p;
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (!world.field_72995_K || worldExt == null) {
            return;
        }
        for (MobEventClient mobEventClient : worldExt.clientMobEvents.values()) {
            mobEventClient.onUpdate();
        }
        if (worldExt.clientWorldEvent != null) {
            worldExt.clientWorldEvent.onUpdate();
        }
    }

    public MobEventBase getRandomWorldMobEvent(World world, ExtendedWorld worldExt) {
        int dimensionID = 0;
        if (world.field_73011_w != null) {
            dimensionID = world.field_73011_w.getDimension();
        }
        if (Utilities.isHalloween() && this.worldMobEvents.containsKey("halloween") && this.worldMobEvents.get("halloween").isEnabled() && this.worldMobEvents.get("halloween").canStart(world, worldExt)) {
            return this.worldMobEvents.get("halloween");
        }
        Map<String, MobEventBase> worldMobEventSet = this.worldMobEventSets.get("main");
        if (Utilities.isYuletide() && this.worldMobEventSets.containsKey("yule")) {
            worldMobEventSet = this.worldMobEventSets.get("yule");
        }
        ArrayList<MobEventBase> validMobEvents = new ArrayList<MobEventBase>();
        int totalWeights = 0;
        for (MobEventBase mobEventEntry : worldMobEventSet.values()) {
            if (!mobEventEntry.isEnabled() || !mobEventEntry.canStart(world, worldExt)) continue;
            totalWeights += mobEventEntry.weight;
            validMobEvents.add(mobEventEntry);
        }
        if (totalWeights <= 0) {
            return null;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = world.field_73012_v.nextInt(totalWeights - 1) + 1;
        }
        int searchWeight = 0;
        MobEventBase mobEvent = null;
        for (MobEventBase mobEventEntry : validMobEvents) {
            if (!mobEventEntry.isEnabled()) continue;
            mobEvent = mobEventEntry;
            if (mobEventEntry.weight + searchWeight > randomWeight) break;
            searchWeight += mobEventEntry.weight;
        }
        return mobEvent;
    }
}

